/*! \file
**********************************************************************************
*Title:                         Discretix Certificate Handling Toolkit source file
*
* Filename:                     tlk_cert_types_pkcs10.h 
*
* Project, Target, subsystem:   Certificate Handling Toolkit, OMA DRM
*
* Created:                      11.02.2009
*
* Modified:                     11.02.2009
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_CERT_TYPES_PKCS10_H_ 
#define _TLK_CERT_TYPES_PKCS10_H_
#ifdef __cplusplus
extern "C" {
#endif

#include "DX_VOS_BaseTypes.h"

#include "tlk_cert_types_der.h"

/************************************************************************/
/* The following structure is used as input for Request Creation API    */
/************************************************************************/
    typedef struct
    {   /*!<  Request version number. According to PKCS #10 is the version number, 
        for compatibility with future revisions of this document.  
        It shall be 0 for this version of the standard.                         **/
        TLK_CERT_DER_VersionNumber_t         versionNumber;

        /*!<   Subject name distinguished name of certificate subject.
        Currently we support only basic names:
            commonName
            countryName
            localityName
            stateOrProvinceName
            organizationName
            organizationalUnitName 
            serialNumber                                            **/
        TLK_CERT_DER_SubjectNameParams_t     subjectName;

        /*!< subjectPKInfo contains information about the public key being certified.
             in addition this field contains private exponent buffer for sining      **/
        TLK_CERT_DER_KeyPairData_t           subjectPKInfo;

        /*!< attributes is a collection of attributes providing additional
            information about the subject of the certificate.
            Currently we support attributes which are required for IEEE 1667 standard **/
        TLK_CERT_DER_Attributes_t            attributes;

        /*!< signature algorithm which is used for creation signature.
             We support md5WithRSAEncryption algorithm **/
        TLK_CERT_DER_SignatureAlg_t          signatureAlgorithm;
    }TLK_CERT_PKCS10_RequestCreateParams_t;

#ifdef __cplusplus
}
#endif
#endif
